/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css1;

import org.w3c.css.parser.CssPrinterStyle;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.properties.css1.CssFontConstantCSS1;
import org.w3c.css.properties.css1.CssFontFamilyCSS1;
import org.w3c.css.properties.css1.CssFontSizeCSS1;
import org.w3c.css.properties.css1.CssFontStyleCSS1;
import org.w3c.css.properties.css1.CssFontVariantCSS1;
import org.w3c.css.properties.css1.CssFontWeightCSS1;
import org.w3c.css.properties.css1.CssLineHeightCSS1;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssValue;

public class CssFontCSS1
extends CssProperty
implements CssOperator,
CssFontConstantCSS1 {
    CssValue value;
    CssFontStyleCSS1 fontStyle;
    CssFontVariantCSS1 fontVariant;
    CssFontWeightCSS1 fontWeight;
    CssFontSizeCSS1 fontSize;
    CssLineHeightCSS1 lineHeight;
    CssFontFamilyCSS1 fontFamily;
    static CssIdent normal = new CssIdent("normal");

    public CssFontCSS1() {
    }

    public CssFontCSS1(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        CssValue val = expression.getValue();
        char op = ' ';
        boolean find = true;
        int max_values = 3;
        int normalNb = 0;
        while (find && max_values-- > 0) {
            find = false;
            val = expression.getValue();
            op = expression.getOperator();
            if (val == null) {
                throw new InvalidParamException("few-value", this.getPropertyName(), ac);
            }
            if (val.equals(normal)) {
                ++normalNb;
                expression.next();
                find = true;
            }
            if (!find && this.fontStyle == null) {
                try {
                    this.fontStyle = new CssFontStyleCSS1(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.fontVariant == null) {
                try {
                    this.fontVariant = new CssFontVariantCSS1(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.fontWeight == null) {
                try {
                    this.fontWeight = new CssFontWeightCSS1(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find || op == 32) continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        CssExpression normalExpr = new CssExpression();
        normalExpr.addValue(normal);
        for (int i = 0; i < normalNb; ++i) {
            if (this.fontStyle == null) {
                this.fontStyle = new CssFontStyleCSS1(ac, normalExpr);
                normalExpr.starts();
                continue;
            }
            if (this.fontVariant == null) {
                this.fontVariant = new CssFontVariantCSS1(ac, normalExpr);
                normalExpr.starts();
                continue;
            }
            if (this.fontWeight != null) continue;
            this.fontWeight = new CssFontWeightCSS1(ac, normalExpr);
            normalExpr.starts();
        }
        val = expression.getValue();
        op = expression.getOperator();
        if (val == null) {
            throw new InvalidParamException("few-value", this.getPropertyName(), ac);
        }
        this.fontSize = new CssFontSizeCSS1(ac, expression);
        if (op == '/') {
            op = expression.getOperator();
            this.lineHeight = new CssLineHeightCSS1(ac, expression);
        }
        if (op != ' ' || expression.getValue() == null) {
            expression.starts();
            throw new InvalidParamException("few-value", expression.toString(), ac);
        }
        this.fontFamily = new CssFontFamilyCSS1(ac, expression, true);
        this.setByUser();
    }

    public CssFontCSS1(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public Object get() {
        return null;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        String ret = "";
        if (this.fontStyle != null) {
            ret = ret + " " + this.fontStyle;
        }
        if (this.fontVariant != null) {
            ret = ret + " " + this.fontVariant;
        }
        if (this.fontWeight != null) {
            ret = ret + " " + this.fontWeight;
        }
        if (this.fontSize != null) {
            ret = ret + " " + this.fontSize;
        }
        if (this.lineHeight != null) {
            ret = ret + "/" + this.lineHeight;
        }
        if (this.fontFamily.size() != 0) {
            ret = ret + " " + this.fontFamily;
        }
        return ret.substring(1);
    }

    public void setImportant() {
        super.setImportant();
        if (this.value == null) {
            if (this.fontStyle != null) {
                this.fontStyle.important = true;
            }
            if (this.fontVariant != null) {
                this.fontVariant.important = true;
            }
            if (this.fontWeight != null) {
                this.fontWeight.important = true;
            }
            if (this.fontSize != null) {
                this.fontSize.important = true;
            }
            if (this.lineHeight != null) {
                this.lineHeight.important = true;
            }
            if (this.fontFamily != null) {
                this.fontFamily.important = true;
            }
        }
    }

    public boolean getImportant() {
        if (this.value != null) {
            return super.getImportant();
        }
        return !(this.fontStyle != null && !this.fontStyle.important || this.fontVariant != null && !this.fontVariant.important || this.fontWeight != null && !this.fontWeight.important || this.fontSize != null && !this.fontSize.important || this.lineHeight != null && !this.lineHeight.important || this.fontFamily != null && !this.fontFamily.important);
    }

    public void print(CssPrinterStyle printer) {
        if (this.value != null) {
            printer.print(this);
        } else if (!(this.fontStyle == null || this.fontVariant == null || this.fontWeight == null || this.fontSize == null || this.lineHeight == null || this.fontFamily == null || !this.getImportant() && (this.fontStyle.important || this.fontVariant.important || this.fontWeight.important || this.fontSize.important || this.lineHeight.important || this.fontFamily.important))) {
            printer.print(this);
        } else {
            if (this.fontStyle != null) {
                this.fontStyle.print(printer);
            }
            if (this.fontVariant != null) {
                this.fontVariant.print(printer);
            }
            if (this.fontWeight != null) {
                this.fontWeight.print(printer);
            }
            if (this.fontSize != null) {
                this.fontSize.print(printer);
            }
            if (this.lineHeight != null) {
                this.lineHeight.print(printer);
            }
            if (this.fontFamily != null && (this.fontFamily.isSoftlyInherited() || this.fontFamily.size() != 0)) {
                this.fontFamily.print(printer);
            }
        }
    }

    public void addToStyle(ApplContext ac, CssStyle style) {
        if (this.value != null) {
            ((Css1Style)style).cssFontCSS1.value = this.value;
        } else {
            if (this.fontStyle != null) {
                this.fontStyle.addToStyle(ac, style);
            }
            if (this.fontVariant != null) {
                this.fontVariant.addToStyle(ac, style);
            }
            if (this.fontSize != null) {
                this.fontSize.addToStyle(ac, style);
            }
            if (this.fontWeight != null) {
                this.fontWeight.addToStyle(ac, style);
            }
            if (this.lineHeight != null) {
                this.lineHeight.addToStyle(ac, style);
            }
            if (this.fontFamily != null) {
                this.fontFamily.addToStyle(ac, style);
            }
        }
    }

    public void setInfo(int line, String source) {
        super.setInfo(line, source);
        if (this.value == null) {
            if (this.fontStyle != null) {
                this.fontStyle.setInfo(line, source);
            }
            if (this.fontVariant != null) {
                this.fontVariant.setInfo(line, source);
            }
            if (this.fontWeight != null) {
                this.fontWeight.setInfo(line, source);
            }
            if (this.fontSize != null) {
                this.fontSize.setInfo(line, source);
            }
            if (this.lineHeight != null) {
                this.lineHeight.setInfo(line, source);
            }
            if (this.fontFamily != null) {
                this.fontFamily.setInfo(line, source);
            }
        }
    }

    public boolean equals(CssProperty property) {
        return false;
    }

    public void setSelectors(CssSelectors selector) {
        super.setSelectors(selector);
        if (this.fontStyle != null) {
            this.fontStyle.setSelectors(selector);
        }
        if (this.fontVariant != null) {
            this.fontVariant.setSelectors(selector);
        }
        if (this.fontWeight != null) {
            this.fontWeight.setSelectors(selector);
        }
        if (this.fontSize != null) {
            this.fontSize.setSelectors(selector);
        }
        if (this.lineHeight != null) {
            this.lineHeight.setSelectors(selector);
        }
        if (this.fontFamily != null) {
            this.fontFamily.setSelectors(selector);
        }
    }

    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css1Style)style).getFontCSS1();
        }
        return ((Css1Style)style).cssFontCSS1;
    }

    public String getPropertyName() {
        return "font";
    }
}

